<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Подтверждение двухфакторной аутентификации';
$this->params['breadcrumbs'][] = $this->title;
?>

<style>
    .site-verify-otp {
        max-width: 500px;
        margin: 0 auto;
    }
    .row {
        display: flex;
        flex-wrap: wrap;
        margin: 0 -15px;
    }
    .col-lg-5 {
        flex: 0 0 41.666667%;
        max-width: 41.666667%;
        padding: 0 15px;
        box-sizing: border-box;
    }
    .form-group {
        margin-bottom: 15px;
    }
    .form-control {
        display: block;
        width: 100%;
        padding: 8px 12px;
        font-size: 14px;
        line-height: 1.42857143;
        color: #555;
        background-color: #fff;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-sizing: border-box;
    }
    .btn {
        display: inline-block;
        padding: 8px 16px;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857143;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        cursor: pointer;
        border: 1px solid transparent;
        border-radius: 4px;
        text-decoration: none;
        color: #fff;
        background-color: #337ab7;
        border-color: #2e6da4;
    }
    .btn:hover {
        background-color: #286090;
        border-color: #204d74;
    }
    .help-block {
        color: #a94442;
        font-size: 12px;
        margin-top: 5px;
    }
</style>

<div class="site-verify-otp">
    <h1><?= Html::encode($this->title) ?></h1>

    <p>Пожалуйста, введите код из вашего приложения аутентификатора:</p>

    <div class="row">
        <div class="col-lg-5">
            <?php $form = ActiveForm::begin(['id' => 'verify-otp-form']); ?>

            <div class="form-group">
                <?= $form->field($model, 'otp_code')->textInput([
                    'class' => 'form-control',
                    'autofocus' => true,
                    'autocomplete' => 'off',
                    'placeholder' => '000000',
                    'maxlength' => 6
                ]) ?>
            </div>

            <div class="form-group">
                <?= Html::submitButton('Подтвердить', ['class' => 'btn', 'name' => 'verify-button']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>