<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Регистрация';
$this->params['breadcrumbs'][] = $this->title;
?>

<style>
    .site-signup {
        max-width: 500px;
        margin: 0 auto;
    }
    .row {
        display: flex;
        flex-wrap: wrap;
        margin: 0 -15px;
    }
    .col-lg-5 {
        flex: 0 0 41.666667%;
        max-width: 41.666667%;
        padding: 0 15px;
        box-sizing: border-box;
    }
    .form-group {
        margin-bottom: 15px;
    }
    .form-control {
        display: block;
        width: 100%;
        padding: 8px 12px;
        font-size: 14px;
        line-height: 1.42857143;
        color: #555;
        background-color: #fff;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-sizing: border-box;
    }
    .btn {
        display: inline-block;
        padding: 8px 16px;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857143;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        cursor: pointer;
        border: 1px solid transparent;
        border-radius: 4px;
        text-decoration: none;
        color: #fff;
        background-color: #5cb85c;
        border-color: #4cae4c;
    }
    .btn:hover {
        background-color: #449d44;
        border-color: #398439;
    }
    .alert {
        padding: 15px;
        margin-bottom: 20px;
        border: 1px solid transparent;
        border-radius: 4px;
    }
    .alert-success {
        color: #155724;
        background-color: #d4edda;
        border-color: #c3e6cb;
    }
    .alert-info {
        color: #0c5460;
        background-color: #d1ecf1;
        border-color: #bee5eb;
    }
    .help-block {
        color: #a94442;
        font-size: 12px;
        margin-top: 5px;
    }
    .login-link {
        margin-top: 20px;
        text-align: center;
    }
    .login-link a {
        color: #337ab7;
        text-decoration: none;
    }
    .login-link a:hover {
        text-decoration: underline;
    }
</style>

<div class="site-signup">
    <h1><?= Html::encode($this->title) ?></h1>

    <p>Заполните следующие поля для регистрации:</p>

    <div class="row">
        <div class="col-lg-5">
            <?php $form = ActiveForm::begin(['id' => 'signup-form']); ?>

            <div class="form-group">
                <?= $form->field($model, 'username')->textInput([
                    'class' => 'form-control',
                    'autofocus' => true,
                    'placeholder' => 'Введите имя пользователя (минимум 3 символа)'
                ]) ?>
            </div>

            <div class="form-group">
                <?= $form->field($model, 'email')->textInput([
                    'class' => 'form-control',
                    'placeholder' => 'Введите email'
                ]) ?>
            </div>

            <div class="form-group">
                <?= $form->field($model, 'password')->passwordInput([
                    'class' => 'form-control',
                    'placeholder' => 'Введите пароль (минимум 6 символов)'
                ]) ?>
            </div>

            <div class="form-group">
                <?= $form->field($model, 'confirm_password')->passwordInput([
                    'class' => 'form-control',
                    'placeholder' => 'Подтвердите пароль'
                ]) ?>
            </div>

            <div class="form-group">
                <?= Html::submitButton('Зарегистрироваться', ['class' => 'btn', 'name' => 'signup-button']) ?>
            </div>

            <div class="alert alert-info">
                <strong>ℹ Примечание:</strong> После регистрации вы сможете настроить двухфакторную аутентификацию в своем профиле.
            </div>

            <div class="login-link">
                Уже есть аккаунт? <?= Html::a('Войти', ['/site/login']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>