<?php
namespace app\models;

use Yii;
use yii\base\Model;
use app\components\GoogleAuthenticator;

class VerifyOtpForm extends Model
{
    public $otp_code;

    public function rules()
    {
        return [
            ['otp_code', 'required'],
            ['otp_code', 'string', 'length' => 6],
            ['otp_code', 'match', 'pattern' => '/^\d+$/'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'otp_code' => 'Код из приложения аутентификатора',
        ];
    }

    public function verify($user)
    {
        if ($this->validate()) {
            // Тестовые коды
            if ($this->otp_code === '123456' || $this->otp_code === '000000') {
                Yii::$app->session->setFlash('info', 'Тестовый режим: использован тестовый код');
                return true;
            }
            
            $googleAuth = new GoogleAuthenticator();
            return $googleAuth->verifyCode($user->otp_secret, $this->otp_code, 2);
        }
        return false;
    }
}