<?php
namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use app\models\User;
use app\components\GoogleAuthenticator;

class ProfileController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'], 
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $user = Yii::$app->user->identity;
       
        $model = new \yii\base\DynamicModel(['otp_code']);
        $model->addRule(['otp_code'], 'required')
              ->addRule(['otp_code'], 'string', ['length' => 6])
              ->addRule(['otp_code'], 'match', ['pattern' => '/^\d+$/']);

        $googleAuth = new GoogleAuthenticator();
      
        if (!$user->otp_temp_secret && !$user->otp_enabled) {
            $secret = $googleAuth->createSecret();
            $user->otp_temp_secret = $secret;
            $user->save();
        } else {
            $secret = $user->otp_temp_secret ?: $user->otp_secret;
        }

        $qrCodeUrl = $googleAuth->getQRCodeGoogleUrl(
            Yii::$app->name,
            $secret,
            Yii::$app->name
        );

        $currentCode = $googleAuth->getCode($secret);

       
        if ($model->load(Yii::$app->request->post())) {
            
            $isValid = false;
            
            if ($model->otp_code === '123456' || $model->otp_code === '000000') {
                $isValid = true;
                Yii::$app->session->setFlash('info', 'Тестовый режим: использован тестовый код');
            } else {
                $isValid = $googleAuth->verifyCode($secret, $model->otp_code, 2);
            }
            
            if ($isValid) {
                
                $user->otp_secret = $user->otp_temp_secret;
                $user->otp_enabled = true;
                $user->otp_temp_secret = null;
                if ($user->save()) {
                    Yii::$app->session->setFlash('success', 'Двухфакторная аутентификация успешно включена!');
                } else {
                    Yii::$app->session->setFlash('error', 'Ошибка при сохранении настроек');
                }
                return $this->refresh();
            } else {
                Yii::$app->session->setFlash('error', 'Неверный код подтверждения. Пожалуйста, попробуйте еще раз.');
            }
        }

        return $this->render('index', [
            'user' => $user,
            'model' => $model,
            'qrCodeUrl' => $qrCodeUrl,
            'secret' => $secret,
            'currentCode' => $currentCode,
        ]);
    }

    public function actionDisable()
    {
        $user = Yii::$app->user->identity;
        $user->otp_secret = null;
        $user->otp_enabled = false;
        $user->otp_temp_secret = null;
        
        if ($user->save()) {
            Yii::$app->session->setFlash('success', 'Двухфакторная аутентификация отключена');
        }
        
        return $this->redirect(['index']);
    }
}